<?php

namespace Modules\User\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function parent()
    {
        return $this->belongsTo('Message', 'message_id');
    }

    public function replies()
    {
        return $this->hasMany('Message', 'message_id');
    }

}